<?php

namespace OpenEMR\Tests\Unit\FHIR\SMART;

use OpenEMR\Common\Auth\OpenIDConnect\Repositories\ClientRepository;
use OpenEMR\Common\Csrf\CsrfUtils;
use OpenEMR\Common\Logging\SystemLogger;
use OpenEMR\FHIR\SMART\ClientAdminController;
use OpenEMR\FHIR\SMART\ExternalClinicalDecisionSupport\RouteController;
use PHPUnit\Framework\TestCase;
use Symfony\Component\BrowserKit\Response;
use Symfony\Component\HttpFoundation\Request;
use Twig\Environment;

class ClientAdminControllerTest extends TestCase
{
    protected ClientAdminController $controller;
    protected ClientRepository $mockRepository;
    protected SystemLogger $mockLogger;

    protected Environment $mockTwig;

    protected function setUp(): void
    {
        parent::setUp(); // TODO: Change the autogenerated stub
        // setup the CSRF key for our session values
        CsrfUtils::setupCsrfKey();
        $_SESSION['authUser'] = 'admin';
        $this->mockRepository = $this->createMock(ClientRepository::class);
        $this->mockLogger = $this->createMock(SystemLogger::class);
        $this->mockTwig = $this->createMock(Environment::class);
        $this->controller = new ClientAdminController($this->mockRepository, $this->mockLogger, $this->mockTwig, 'test-url.php');
    }

    public function testDispatch()
    {
        // smoke test
        $request = new Request(['action' => 'list/']);
        $this->mockTwig->expects($this->once())
            ->method('render')
            ->willReturn('Client Registrations');
        $this->controller->dispatch($request);
        // regex of "Client Name / Client ID"
        $this->expectOutputRegex('/Client Registrations/');
    }

    public function testDispatchWithExternalCDR()
    {
        // smoke test, individual routes will be handled elsewhere
        $request = new Request(['action' => RouteController::EXTERNAL_CDR_ACTION . '/edit/1']);
        $router = $this->createMock(RouteController::class);
        $router->expects($this->once())->method('dispatch')->willReturn(new Response('', 200));
        $router->expects($this->once())->method("supportsRequest")->willReturn(true);
        $this->controller->setExternalCDRController($router);
        $response = $this->controller->dispatch($request);
        $this->assertInstanceOf(Response::class, $response);
        $this->assertEquals(200, $response->getStatusCode());
    }
}
