/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.util;

import com.vladsch.flexmark.Extension;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.profiles.pegdown.PegdownOptionsAdapter;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.schemaspy.model.Table;
import org.schemaspy.util.naming.FileNameGenerator;

/*
 * Exception performing whole class analysis ignored.
 */
public class Markdown {
    private static final HashMap<String, String> pages = new HashMap();
    private final String markdownText;
    private final String rootPath;
    private final Parser parser;
    private final HtmlRenderer renderer;

    public Markdown(String markdownText, String rootPath) {
        this(markdownText, rootPath, PegdownOptionsAdapter.flexmarkOptions((boolean)true, (int)65527, (Extension[])new Extension[0]));
    }

    public Markdown(String markdownText, String rootPath, DataHolder options) {
        this(markdownText, rootPath, Parser.builder((DataHolder)options).build(), HtmlRenderer.builder((DataHolder)options).build());
    }

    public Markdown(String markdownText, String rootPath, Parser parser, HtmlRenderer renderer) {
        this.markdownText = markdownText;
        this.rootPath = rootPath;
        this.parser = parser;
        this.renderer = renderer;
    }

    public String toHtml() {
        if (this.markdownText == null) {
            return null;
        }
        return this.renderer.render((Node)this.parser.parse(this.addReferenceLink())).trim();
    }

    public static void registryPage(Collection<Table> tables) {
        String DOT_HTML = ".html";
        tables.stream().filter(table -> !table.isLogical()).forEach(table -> {
            String tablePath = "tables/" + new FileNameGenerator(table.getName()).value() + ".html";
            pages.put(table.getName(), tablePath);
        });
    }

    public static String pagePath(String page) {
        return (String)pages.get(page);
    }

    private String addReferenceLink() {
        StringBuilder text = new StringBuilder(this.markdownText);
        String newLine = "\r\n";
        Pattern p = Pattern.compile("\\[(.*?)]");
        Matcher m = p.matcher(this.markdownText);
        ArrayList<String> links = new ArrayList<String>();
        while (m.find()) {
            links.add(m.group(1));
        }
        if (!links.isEmpty()) {
            text.append(newLine).append(newLine);
        }
        for (String link : links) {
            String anchorLink = "";
            String pageLink = link;
            int anchorPosition = link.lastIndexOf(46);
            if (anchorPosition > -1) {
                anchorLink = link.substring(anchorPosition + 1).trim();
                pageLink = link.substring(0, anchorPosition);
            }
            String path = this.rootPath + Markdown.pagePath((String)pageLink);
            if (!"".equals(anchorLink)) {
                path = path + "#" + anchorLink;
            }
            text.append("[").append(link).append("]: ./").append(path).append(newLine);
        }
        return text.toString();
    }
}

