/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.diagram;

import java.io.File;
import org.schemaspy.output.diagram.DiagramResult;
import org.schemaspy.output.diagram.RenderException;
import org.schemaspy.output.diagram.Renderer;

public class TableDiagram {
    private final Renderer renderer;
    private final File tablesDir;

    public TableDiagram(Renderer renderer, File tablesDir) {
        this.renderer = renderer;
        this.tablesDir = tablesDir;
    }

    public DiagramResult generateTableDiagram(File dotFile, String diagramName) {
        try {
            File diagramFile = new File(this.tablesDir, diagramName + "." + this.renderer.format());
            String diagramMap = this.renderer.render(dotFile, diagramFile);
            return new DiagramResult(diagramFile.getName(), diagramMap, this.renderer.format());
        }
        catch (RenderException diagramException) {
            throw new RenderException("Failed to generate Table diagram", (Throwable)diagramException);
        }
    }
}

