/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.output.diagram;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DiagramResult {
    private static final Pattern MAP_NAME_PATTERN = Pattern.compile("<map.*name=\"([\\w\\s]+).*");
    private final String fileName;
    private final String map;
    private final String imageFormat;

    public DiagramResult(String fileName, String map, String imageFormat) {
        this.fileName = fileName;
        this.map = map;
        this.imageFormat = imageFormat;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getMapName() {
        Matcher matcher;
        if (Objects.nonNull(this.map) && (matcher = MAP_NAME_PATTERN.matcher(this.map)).find()) {
            return matcher.group(1);
        }
        return "";
    }

    public String getMap() {
        return Objects.isNull(this.map) ? "" : this.map.trim();
    }

    public String getImageFormat() {
        return this.imageFormat;
    }

    public boolean isEmbed() {
        return "svg".equalsIgnoreCase(this.imageFormat);
    }
}

